//////////////////////////////////////
//                                  //
//          windowsmedia.js         // 
//                                  //
//////////////////////////////////////
//
//               INSTRUCTIONS
//
// Use this file in your HTML documents by 
// including it in the head section
// of your document:
//
//   <script src="windowsmedia.js"></script>
//
// Then you can make calls to the functions
// described below to manipulate and query
// any named instance of a Windows Media
// audio or video embed.
//
// For example, if you have a Windows Media embed
// called "AudioClip", you can change its
// source with the G2_setSource() method:
//
//   G2_setSource("AudioClip","audio/a1t2p3b.swf");
//
// You could then play the clip with the 
// G2_play() method:
//
//   G2_play("AudioClip");
//
// It is also possible to have multiple embeds
// that have unique names, and you can manage
// all of them with the G2 functions - just
// specify the embed name when making the
// function call.
//
// You will also notice that each function
// takes an optional document object as its
// last parameter.  This gives you the ability
// to control Windows Media embeds in a different
// frame, or even a different window all together.
// All you have to do is build a reference to
// the document which contains the embed bearing
// the name supplied in the function call.
// For example, if there was an embed named "VideoClip"
// in a frame called "VideoFrame" which resides in
// the same frameset as the current document, you could
// stop it, change it's source, then play it
// with the following calls:
//
//   G2_stop("VideoClip",parent.VideoFrame);
//   G2_setSource("VideoClip","video/v1t2p3b.swf",parent.VideoFrame);
//   G2_play("VideoClip",parent.VideoFrame);
//
///////////////////////////////////////////////////////
//                                                   //
//        JavaScript Windows Media Functions         // 
//                                                   //
///////////////////////////////////////////////////////
// object G2_getClipRef(clipName[, doc])             //
// int G2_getPlayState(clipName[, doc])              //
// int G2_getPosition(clipName[, doc])               //
// void G2_setPosition(clipName, pos[, doc])         //
// void G2_setSource(clipName, sourceString[,  doc]) //
// string G2_getSource(clipName[, doc])              //
// int G2_getLength(clipName[, doc])                 //
// void G2_stop(clipName[, doc])                     //
// void G2_play(clipName[, doc])                     //
// void G2_pause(clipName[, doc])                    //
// void G2_setVolume(clipName, vol[, doc])           //
// int G2_getVolume(clipName[, doc])                 //
///////////////////////////////////////////////////////
//                                              //
//      Windows Media Play State Constants      //
//////////////////////////////////////////////////
	var G2_STOPPED    = 0;
	var G2_PLAYING    = 2;
	var G2_PAUSED     = 1;
	var G2_WAITING    = 3;

	var debugReal = true;
	
	var recCount = 0;

	function G2_getClipRef(clipName, doc)
	{
		recCount = 0;
		if (G2_getClipRef.arguments.length < 2)
		{
			doc = document;
		}
		
		return G2_getClipRef2(clipName, doc);
	}

	function G2_getClipRef2(clipName, doc)
	{
		var clipRef = null;	
		
		// Base Case 1
		if (navigator.appName == "Microsoft Internet Explorer") 
		{
			clipRef = eval("doc." + clipName);
			return clipRef;
		}

		// Base Case 2
		if (recCount++ >= 100) 
		{
			return null;
		}

		// Base Case 3
		if (doc.embeds.length > 0) // look for embed in the document	
		{
			if (doc.embeds[clipName] != null) 
			{
				clipRef = doc.embeds[clipName];
				return clipRef;
			}			
		}	

		// Possible Recursion	
		for (var i=0;i<doc.layers.length;i++) // for each layer in the document
		{
			//alert("You have found layer: " + doc.layers[i].id);
			if (doc.layers[i].document.embeds.length > 0)
			{
				if (doc.layers[i].document.embeds[clipName] != null) 
				{
					clipRef = doc.layers[i].document.embeds[clipName];
					return clipRef;
				}
			}
			if (doc.layers[i].document.layers.length > 0) 
				if ( (clipRef = G2_getClipRef2(clipName,doc.layers[i].document)) != null ) 
					break;
		}
		
		return clipRef;
	}

	
	function G2_getPlayState(clipName, doc)	
	{
		if (G2_getPlayState.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_getPlayState():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return G2_STOPPED;
		}
		else
		{
			return clipRef.PlayState;
		}
	}

	function G2_getPosition(clipName, doc)	
	{	
		if (G2_getPosition.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_getPosition():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return 0;
		}
		else
		{
			return Math.round(clipRef.CurrentPosition*1000);
		}
	}

	function G2_setPosition(clipName, pos, doc)	
	{	
		if (G2_setPosition.arguments.length < 3)
		{
			doc = document;
		}		

		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_setPosition():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			return clipRef.CurrentPosition = (pos/1000);
		}
	}

	var tempDocRef = null;
	function G2_setSourcePlay(clipName, sourceString, doc)	
	{
		if (G2_setSourcePlay.arguments.length < 3)
		{
			doc = document;
		}		
		tempDocRef = doc;
		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_setSourcePlay():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			clipRef.AutoStart = true;
			clipRef.FileName = sourceString;
			//setTimeout("G2_play('" + clipName + "',tempDocRef)",1000);
		}
	}

	function G2_setSource(clipName, sourceString, doc)	
	{
		if (G2_setSource.arguments.length < 3)
		{
			doc = document;
		}		

		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_setSource():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			clipRef.FileName = sourceString;
		}
	}

	function G2_getSource(clipName, doc)	
	{
		if (G2_getSource.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_getSource():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return null;
		}
		else
		{
			return cleanupURL(clipRef.FileName);
		}
	}

	function G2_getLength(clipName, doc)	
	{	
		if (G2_getLength.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_getLength():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return null;
		}
		else
		{
			return clipRef.currentMedia.duration;
		}
	}

	function cleanupURL(url)
	{
		url = url + "";
		for (var i=0;i<url.length;i++)
		{
			if (url.charCodeAt(i) < 32 || url.charCodeAt(i) > 126)
			{
				//alert("Illegal Character Found at position " + i);
				url = url.slice(0,i) + url.slice(i+1,url.length);
			} 
			else if (url.charAt(i) == "\\")
			{
				url = url.slice(0,i) + "/" + url.slice(i+1,url.length);
			}
		}
		return url;
	}

	function G2_stop(clipName, doc)	
	{
		if (G2_stop.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_stop():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			clipRef.Stop();
			clipRef.CurrentPosition = 0;
		}
	}	

	function G2_play(clipName, doc)
	{
		if (G2_play.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_play():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			clipRef.Play();
		}
	}

	function G2_pause(clipName, doc)
	{	
		if (G2_pause.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_pause():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			clipRef.Pause();
		}
	}
	
	function G2_getVolume(clipName, doc)	
	{
		if (G2_getVolume.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_getVolume():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return 0;
		}
		else
		{
			return Math.round((clipRef.Volume+10000)/100);
		}
	}

	function G2_setVolume(clipName, vol, doc)	
	{
		if (G2_setVolume.arguments.length < 3)
		{
			doc = document;
		}		

		var clipRef = G2_getClipRef(clipName,doc);		

		if (clipRef == null)
		{
			if (debugReal)
				alert("In call to G2_setVolume():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			return clipRef.Volume = (vol*100-10000);
		}
	}



